CREATE TABLE Productos_Forma_Pago (
	Id_Producto		VARCHAR(14) NOT NULL,
	Id_Tipo_Val		CHAR(3) NOT NULL,
	Id_Tarjeta		VARCHAR(10) NOT NULL,
	Cuota			TINYINT NOT NULL,
	Nota			TEXT,
	CONSTRAINT PK_ProdFP_PorId PRIMARY KEY CLUSTERED (
		Id_Producto,
		Id_Tipo_Val,
		Id_Tarjeta,
		Cuota
		)
)
GO

ALTER TABLE Productos_Forma_Pago  ADD CONSTRAINT FK_ProdFP_Productos FOREIGN KEY(Id_Producto)
REFERENCES Productos (Id_Producto)
GO

CREATE INDEX IX_ProdFP_PorTipoVal ON Productos_Forma_Pago (Id_Tipo_Val)

CREATE INDEX IX_ProdFP_PorTarj ON Productos_Forma_Pago (Id_Tarjeta)

ALTER TABLE Productos_Forma_Pago  ADD CONSTRAINT FK_ProdFP_Valores_Tipos FOREIGN KEY(Id_Tipo_Val)
REFERENCES Valores_Tipos (Id_Tipo_Val)
GO

ALTER TABLE Productos_Forma_Pago ADD CONSTRAINT FK_ProdFP_Tarjetas FOREIGN KEY(Id_Tarjeta)
REFERENCES Valores_Tarjetas_Cred (Id_Tarjeta)
GO